using System;
using System.Globalization;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        long[] h = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);

        double[] ans = new double[n];
        for (int i = 0; i < n; i++) ans[i] = double.PositiveInfinity;

        // LEFT PASS (lines with slope +1)
        long bestH = long.MinValue;   // stores max of (h[j] - x[j])
        long bestX = 0;

        for (int i = 0; i < n; i++)
        {
            long val = bestH + x[i]; // max L_j(x_i)

            if (val >= h[i])
            {
                // nearest point is horizontally closest
                double d = x[i] - bestX;
                if (d < ans[i]) ans[i] = d;
            }

            long candidate = h[i] - x[i];
            if (candidate > bestH)
            {
                bestH = candidate;
                bestX = x[i];
            }
        }

        // RIGHT PASS (lines with slope -1)
        bestH = long.MinValue; // stores max of (h[j] + x[j])
        bestX = 0;

        for (int i = n - 1; i >= 0; i--)
        {
            long val = bestH - x[i]; // max R_j(x_i)

            if (val >= h[i])
            {
                double d = bestX - x[i];
                if (d < ans[i]) ans[i] = d;
            }

            long candidate = h[i] + x[i];
            if (candidate > bestH)
            {
                bestH = candidate;
                bestX = x[i];
            }
        }

        // output
        for (int i = 0; i < n; i++)
        {
            if (double.IsPositiveInfinity(ans[i]))
                Console.WriteLine("-1");
            else
                Console.WriteLine(ans[i].ToString("0.########"));
        }
    }
}